import { Request, Response } from 'express';
import { withdrawalsService } from './service';

export const withdrawalsController = {
  // GET /withdrawals
  async history(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { data, error } = await withdrawalsService.getWithdrawalHistoryAndSummary(vendor.id);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, ...data });
  },

  // PATCH /vendors/bank-account
  async updateBankAccount(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { data, error } = await withdrawalsService.updateBankAccount(vendor.id, req.body);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // PATCH /admin/vendors/:id/withdrawal-status
  async updateVendorWithdrawalStatus(req: any, res: Response) {
    const admin = req.admin;
    if (!admin) return res.status(401).json({ error: 'Unauthorized' });
    const { id } = req.params;
    const { data, error } = await withdrawalsService.updateVendorWithdrawalStatus(id, req.body);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // PATCH /admin/withdrawals/global-status
  async updateGlobalWithdrawalStatus(req: any, res: Response) {
    const admin = req.admin;
    if (!admin) return res.status(401).json({ error: 'Unauthorized' });
    const { data, error } = await withdrawalsService.updateGlobalWithdrawalStatus(req.body);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // POST /admin/withdrawals/trigger
  async triggerWithdrawalJob(req: any, res: Response) {
    const admin = req.admin;
    if (!admin) return res.status(401).json({ error: 'Unauthorized' });
    const { data, error } = await withdrawalsService.triggerWithdrawalJob();
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  }
}; 